//
//  Values are 32 bit values laid out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//


//
// Define the severity codes
//


//
// MessageId: EVMSG_GENERAL
//
// MessageText:
//
// General message: %1
//
#define EVMSG_GENERAL                    0x00000000L

//
// MessageId: EVMSG_CRITICAL_FAILURE
//
// MessageText:
//
// Critical failure or bug detected: %1
//
#define EVMSG_CRITICAL_FAILURE           0x00000099L

//
// MessageId: EVMSG_WARNING
//
// MessageText:
//
// Warning message: %1
//
#define EVMSG_WARNING                    0x00000100L

//
// MessageId: EVMSG_START_FAILURE
//
// MessageText:
//
// Startup failure: %1
//
#define EVMSG_START_FAILURE              0x00000101L

//
// MessageId: EVMSG_CREATION_FAILURE
//
// MessageText:
//
// Object creation failure: %1
//
#define EVMSG_CREATION_FAILURE           0x00000102L

//
// MessageId: EVMSG_SECURITY_SETUP_FAILURE
//
// MessageText:
//
// Error during security setup. %1
//
#define EVMSG_SECURITY_SETUP_FAILURE     0x00000103L

//
// MessageId: EVMSG_SECURITY_FAILURE
//
// MessageText:
//
// Security related failure occured. %1
//
#define EVMSG_SECURITY_FAILURE           0x00000104L

//
// MessageId: EVMSG_SECURITY_WARNING
//
// MessageText:
//
// Security warning. %1
//
#define EVMSG_SECURITY_WARNING           0x00000105L

//
// MessageId: EVMSG_OPERATION_FAILURE
//
// MessageText:
//
// Error during service operation. %1
//
#define EVMSG_OPERATION_FAILURE          0x00000106L

//
// MessageId: EVMSG_COMMUNICATION_FAILURE
//
// MessageText:
//
// Communication error during service operation. %1
//
#define EVMSG_COMMUNICATION_FAILURE      0x00000107L

